/****** Object:  UserDefinedFunction [dbo].[UFD_EST_PROD_TRIB]    Script Date: 04/29/2014 23:12:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_EST_PED_CP_EDI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_EST_PED_CP_EDI]
GO
--select * from dbo.UFD_EST_PED_CP_EDI()
CREATE FUNCTION dbo.UFD_EST_PED_CP_EDI () 

RETURNS @ARQUIVO  TABLE ( CD_FILIAL		INT, 
							CD_PED		INT, 
							ARQUIVO     VARCHAR(451),
							CD_FORN		INT)
 
WITH ENCRYPTION AS 
BEGIN 

/*
insert into  EST_PED_CP_PEND_EDI
SELECT cd_emp, cd_filial , cd_ped,0,0,0,getdate()
 FROM  EST_PED_CP 
where
	  cd_ped =36778
	  and cd_filial = 999
*/
	DECLARE @CD_EMP INT, @CD_PED INT, @CD_FILIAL INT, @CD_FORN INT;

	DECLARE  cPedido CURSOR FAST_FORWARD FOR 
	
SELECT DISTINCT TOP 50
  A.CD_EMP
  ,A.CD_PED
  ,A.CD_FILIAL
  ,B.CD_FORN
FROM   EST_PED_CP_PEND_EDI A
       INNER JOIN EST_PED_CP B
               ON A.CD_EMP = B.CD_EMP
                  AND A.CD_PED = B.CD_PED
                  AND A.CD_FILIAL = B.CD_FILIAL
		INNER JOIN EST_PED_CP_PENDENCIA C
               ON C.CD_EMP = B.CD_EMP
                  AND C.CD_PED = B.CD_PED
                  AND C.CD_FILIAL = B.CD_FILIAL
WHERE  A.CD_EMP = 1
       AND A.STS_ENV = 0;
	OPEN cPedido
	
	FETCH NEXT FROM cPedido INTO @CD_EMP, @CD_PED, @CD_FILIAL, @CD_FORN;
	WHILE @@FETCH_STATUS=0
	BEGIN

		INSERT INTO @ARQUIVO
		SELECT TOP 1
			C.CD_FILIAL,
			C.CD_PED,
			'00' --TP_REG  
			+ LEFT( 'ORDE'+ ( CONVERT(VARCHAR, C.CD_FILIAL) + 'P' + CONVERT(VARCHAR, C.CD_PED)  ) + REPLICATE(' ',14),14)	--ID_REG
			+ LEFT(dbo.F_LIMPA_NUMEROS(F.CGC	)+ REPLICATE(' ',35) ,35 )		--ID_ORIG,
			+ LEFT(dbo.F_LIMPA_NUMEROS(T.CGC_CPF)+ REPLICATE(' ',35) ,35 )	--ID_DEST,
			+ REPLICATE(' ',364) --FILLER
			AS ARQUIVO,
			@CD_FORN
		FROM	
			EST_PED_CP C
			INNER JOIN PRC_FILIAL F ON
			C.CD_EMP= F.CD_EMP AND
			C.CD_FILIAL = F.CD_FILIAL 
			INNER JOIN PG_FORN T ON
			C.CD_EMP  = T.CD_EMP AND
			C.CD_FORN = T.CD_FORN  
		where 
			C.CD_EMP = @CD_EMP
			AND C.CD_FILIAL = @CD_FILIAL
			AND C.CD_PED = @CD_PED;

		INSERT INTO @ARQUIVO
		
SELECT TOP 1
			C.CD_FILIAL,
			C.CD_PED,
			'01' --  1-Tipo do Registro
			+ LEFT(CONVERT(VARCHAR, C.CD_PED)+REPLICATE(' ', 15) ,15)	-- 2-Número do Pedido de Compra  
			+ CONVERT(VARCHAR, DT_PREV_ENT,112)	-- 3-Data de Entrega – Data fixa
			+ CONVERT(VARCHAR, DT_PREV_ENT,112)	--4-Data de Entrega Mais Tarde 
			+ CONVERT(VARCHAR, DT_PREV_ENT,112)	--5-Data de Entrega Mais Cedo – 
			+ CONVERT(VARCHAR, C.DT_EMI,112)	--6-Data Emissão do Pedido

			+ CASE WHEN O.TP_MOV = 0	THEN   '001' --	001 = Pedido normal;
					WHEN O.TP_MOV = 3   THEN  '002' --	002 = Pedido Bonificado;
					WHEN O.TP_MOV = 22	THEN  '003' --	003 = Pedido em Consignação;
					WHEN O.TP_MOV = 999 THEN  '004' --	004 = Pedido Vendor;
					WHEN O.TP_MOV = 999 THEN  '005' --	005 = Pedido Compror;
					WHEN O.TP_MOV = 5	THEN  '006' --	006 = Pedido de Demonstração
				ELSE '000' END	-- 000 = Condições Especiais;
	
			+ REPLICATE(' ',20) -- 8-Número da Lista de Preços
			+ REPLICATE(' ',13) -- 9-Número EAN Básico do Cliente
			+ dbo.F_LIMPA_NUMEROS(f.CGC)	-- 10-CGC Básico do Cliente
			+ REPLICATE(' ',13)				--11-N.º EAN do Local de Entrega 

			+ LEFT(dbo.F_RETIRA_CARAC_ESPECIAIS(F.RZ_FILIAL)	+ REPLICATE(' ',35) , 35 ) --12-Razão Social 			
			+ LEFT(dbo.F_RETIRA_CARAC_ESPECIAIS(F.END_FILILAL)	+ REPLICATE(' ',35), 35 ) --13-Logradouro do Local 	 
			+ LEFT(dbo.F_RETIRA_CARAC_ESPECIAIS(F.BAIRRO)		+ REPLICATE(' ',35), 35 ) --14-Bairro/Distrito do Local de Entrega 
			+ LEFT(ISNULL(dbo.F_RETIRA_CARAC_ESPECIAIS(M.DS_MUNICIPIO),'')+ REPLICATE(' ',35), 35 ) --15-Município do Local de Entrega  
			+ LEFT(G.UF, 2 ) --16-UF do Local de Entrega
			+ LEFT(dBO.F_LIMPA_NUMEROS(F.CEP)+ REPLICATE(' ',9) , 9 ) --17-CEP do Local de Entrega
			+ dbo.F_LIMPA_NUMEROS(f.CGC)										-- 18 -CGC do Local de Entrega
			+ LEFT(dBO.F_LIMPA_NUMEROS(F.INSC_EST) + REPLICATE(' ',20), 20)		-- 19-Inscrição Estadual Local p/ Entrega
			+ REPLICATE(' ',13)													-- 20-N.º EAN do local para Faturamento Preencher campo 20 ou 21
			+ dbo.F_LIMPA_NUMEROS(f.CGC)										-- 21-CGC do Destinatário/Faturado
			+ REPLICATE(' ',13)													-- 22-N.º EAN do Fornecedor
			+ dbo.F_LIMPA_NUMEROS(T.CGC_CPF)									-- 23-CGC do Fornecedor
			+ 'CIF'											-- 24-Condição de Entrega
			+ '0000000000'									-- 25-% de Desconto no Pedido
			+ '000000000000000000'							-- 26-Valor dos Encargos de Frete
			+ '001'											-- 27-Tipo do uso da Mercadoria (001 = Mercadoria para revenda; 002 = Merc. P/ consumo próprio; 003 = Operação de Beneficiamento /Triangulação; 004 = Demonstração;005 = Importação;006 = Exportação;007 = Mercadorias gratuitas, ou 008 = Doação)
			+ REPLICATE(' ',25)								-- 28-Número do Contrato
			+ '224'											-- 29-Tipo do Pedido	O	411	X(3)	220 = Pedido Normal;224 = Pedido Urgente, ou 22E = Pedido Colocado pelo Fornecedor
			+ REPLICATE(' ',37)								--30 FILLER
			,@CD_FORN
		FROM	
			EST_PED_CP C

			INNER JOIN GLB_MOV_OP O  ON
			C.CD_NT_MOV = O.CD_MOV_OP  
			INNER JOIN PRC_FILIAL F ON
			C.CD_EMP= F.CD_EMP AND
			C.CD_FILIAL = F.CD_FILIAL 

			INNER JOIN GLB_CID G ON
			F.CD_CID = G.CD_CID

			LEFT JOIN GLB_CID_GLB_MUNICIPIO GM  ON
			G.CD_CID = GM.CD_CID

			LEFT JOIN GLB_MUNICIPIO M  ON
			GM.CD_MUNICIPIO = M.CD_MUNICIPIO

			INNER JOIN PG_FORN T ON
			C.CD_EMP  = T.CD_EMP AND
			C.CD_FORN = T.CD_FORN 
		where 
			C.CD_EMP = @CD_EMP
			AND C.CD_FILIAL = @CD_FILIAL
			AND C.CD_PED = @CD_PED;
	
		INSERT INTO @ARQUIVO
		SELECT TOP 1
			C.CD_FILIAL,
			C.CD_PED,
			'02' -- 1-Tipo do Registro 
			+ RIGHT (REPLICATE('0',2) + CONVERT(VARCHAR, P.QT_PARC),2) -- 2-Nº de Parcelas de Pagamento
			+ '21'		-- 3-Evento de Referência utilizado para iniciar a contagem do prazo de pagto.
			+ ' ' --Ajuste leiaute
			+ '1  '		-- 4–Referência de Tempo
			+  RIGHT('000'+ISNULL((convert(varchar,d.dias)),'030'),3) -- 5–Número de Dias
			+ '0000000000'-- 6-Percentual de Pagamento da Fatura
			+ REPLICATE(' ',427) -- 7-Filler
			,@CD_FORN		
		FROM	
			EST_PED_CP C  
			INNER JOIN GLB_COND_PGTO   P ON 
			C.CD_COND_PGTO = P.CD_COND_PGTO
			LEFT JOIN (select CD_EMP, CD_COND_PGTO, MIN(DIAS_VENCTO) DIAS    
							FROM	GLB_COND_PGTO_cpl 
								GROUP BY CD_EMP, CD_COND_PGTO )  D ON 
			C.CD_COND_PGTO = D.CD_COND_PGTO 
		where 
			C.CD_EMP = @CD_EMP
			AND C.CD_FILIAL = @CD_FILIAL
			AND C.CD_PED = @CD_PED;

		INSERT INTO @ARQUIVO
		SELECT 
			C.CD_FILIAL,
			C.CD_PED,
			'03' -- 1-Tipo do Registro 
			+ RIGHT('000000' + CONVERT(VARCHAR, (ROW_NUMBER () OVER (ORDER BY I.CD_PROD))),6 )--2-N.º da Linha de Item
			+ LEFT(CONVERT(VARCHAR, ISNULL( (SELECT TOP 1 CD_BARRA FROM EST_PROD_CD_BARRA 
												WHERE 
													CD_EMP = I.CD_EMP AND
													CD_PROD = I.CD_PROD 
													AND ISNULL(NAO_USAR_PED_ELETR,0) = 0), ISNULL(W.CD_PROD_FORN,'0') ) ) +  REPLICATE(' ',14), 14 )--3-Código de barra do Item/Produto
			+ CASE WHEN ISNULL((SELECT TOP 1 1 cd FROM EST_PROD_CD_BARRA 
												WHERE 
													CD_EMP = I.CD_EMP AND
													CD_PROD = I.CD_PROD 
													AND ISNULL(NAO_USAR_PED_ELETR,0) = 0), 0) = 0 THEN 'UP ' ELSE 'EN ' END --4-Tipo do Código do Item/Produto

			+ RIGHT( REPLICATE('0',15) + dbo.F_LIMPA_NUMEROS(CONVERT(VARCHAR,convert (int,i.QT_IT))), 15 ) --5-Quantidade Pedida do Item/Produto
			+ '   '--6-Unidade de Medida da Quantidade do Item/Produto
	
			+ CASE WHEN O.TP_MOV = 0	THEN  '001' --	001 = Pedido normal;
					WHEN O.TP_MOV = 3   THEN  '002' --	002 = Pedido Bonificado;
					WHEN O.TP_MOV = 22	THEN  '003' --	003 = Pedido em Consignação;
					WHEN O.TP_MOV = 999 THEN  '004' --	004 = Pedido Vendor;
					WHEN O.TP_MOV = 999 THEN  '005' --	005 = Pedido Compror;
					WHEN O.TP_MOV = 5	THEN  '006' --	006 = Pedido de Demonstração
				ELSE '000' END	-- 000 = Condições Especiais;--7-Tipo de Pedido do Item/Pedido
			+ RIGHT( REPLICATE('0',15) + dbo.F_LIMPA_NUMEROS(CONVERT(VARCHAR,ROUND(i.VLR_IT,3))), 15) --8-Preço Bruto Unitário do Item/Produto
			+ RIGHT( REPLICATE('0',9) +  dbo.F_LIMPA_NUMEROS(CONVERT(VARCHAR,ROUND(i.VLR_IT,2))), 9)  --9-Base do Preço Bruto Unitário do Item/Produto
			+ '   '--10-Unidade de Medida do Preço do Item/Produto 
			+ RIGHT( REPLICATE('0',10) +  dbo.F_LIMPA_NUMEROS(CONVERT(VARCHAR,ROUND(i.PERC_DESC,2))),10)	--11-% de Desconto no Item
			 
			+ '001'--12-Tipo do uso da Mercadoria 001 = Mercadoria para revenda; 002 = Merc. P/ consumo próprio; 003 = Oper. Benefic.-Triangul.;004 = Demonstração;005 = Importação;006 = Exportação;007 = Mercadorias gratuitas, ou 008 = Doação

			+ REPLICATE(' ',364) --13-Filler
			,@CD_FORN 
		FROM	
			EST_PED_CP C 
	
			INNER JOIN GLB_MOV_OP O  ON
			C.CD_NT_MOV = O.CD_MOV_OP 
			
			INNER JOIN EST_PED_CP_IT I  ON
			C.CD_EMP	= I.CD_EMP AND
			C.CD_PED	= I.CD_PED AND
			C.CD_FILIAL = I.CD_FILIAL  

			LEFT JOIN EST_PROD_FORN W ON
			I.CD_EMP	= W.CD_EMP AND
			I.CD_PROD	= W.CD_PROD AND
			C.CD_FORN   = W.CD_FORN 
		where 
			C.CD_EMP = @CD_EMP
			AND C.CD_FILIAL = @CD_FILIAL
			AND C.CD_PED = @CD_PED;; 

		FETCH NEXT FROM cPedido INTO @CD_EMP, @CD_PED, @CD_FILIAL,@CD_FORN;
	END
	CLOSE cPedido;
	DEALLOCATE cPedido;

	UPDATE A
	SET
		ARQUIVO = UPPER(ARQUIVO)	
	FROM 
		@ARQUIVO A;

	RETURN 
 END
